package ga.examples.quadratic;

import ga.core.goperators.IMutationOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.validation.GAContext;

public class QuadraticPointMutationOp extends ProbabilityOp implements
    IMutationOp<QuadraticIndividual> {

  public QuadraticPointMutationOp(final int pMutate) {
    super(pMutate);
  }

  @Override
  public QuadraticIndividual mutate(final QuadraticIndividual individual,
      final GAContext context) {
    final QuadraticIndividual newInd = individual.clone();

    if (doOperate()) {
      final int iMutate = getRandom().nextInt(
          QuadraticIndividual.PARAMETER_COUNT);

      final int oldNum = newInd.getGenotype().get(iMutate);

      final int newNum = (oldNum + getRandom().nextInt(
          QuadraticIndividual.MAX_NUM))
          % QuadraticIndividual.MAX_NUM;
      newInd.getGenotype().set(iMutate, newNum);
    }

    return newInd;
  }
}
